﻿Public Class Form1
    'デザイナでの作業
    'ボタンを一つ左上に配置し、Textプロパティを「描画」に設定する
    'ボタンをダブルクリックして下記のButton1_Clickを作成する

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim g As Graphics
        Dim ペン As Pen
        g = Me.CreateGraphics
        ペン = New Pen(Color.Black)
        Dim i, j, x1, y1, x2, y2 As Integer

        '中心の位置、半径、頂点の数の設定
        Const 中心X As Integer = 250
        Const 中心Y As Integer = 250
        Const 半径 As Integer = 200
        Const 頂点の数 As Integer = 20

        '計算で使用する角度を格納する変数の定義
        Dim 角度1, 角度2 As Double

        '画面の描画を背景色で塗りつぶす
        g.Clear(Me.BackColor)

        '全体を覆う円を描く。円は「円を描く」という関数を作成し、それを使って行う
        円を描く(中心X, 中心Y, 半径, g, ペン)

        'すべての頂点と頂点の間で線を結ぶ
        For j = 1 To 頂点の数
            For i = j + 1 To 頂点の数
                'j 番目の点の座標 (x1, y1) を計算する
                'その時の角度を計算し、円周のｘ座標、円周のｙ座標という関数を使って計算する
                角度1 = j * 2 * Math.PI / 頂点の数
                x1 = 円周のｘ座標(中心X, 半径, 角度1)
                y1 = 円周のｙ座標(中心Y, 半径, 角度1)
                角度2 = i * 2 * Math.PI / 頂点の数
                'i 番目の点の座標（x2, y2) を計算する
                x2 = 円周のｘ座標(中心X, 半径, 角度2)
                y2 = 円周のｙ座標(中心Y, 半径, 角度2)
                'j 番目の点と i 番目の点の間に線を引く
                g.DrawLine(ペン, x1, y1, x2, y2)
            Next
        Next
    End Sub

    '中心のx座標が「x」、半径が「半径」、円の一番下の点から反時計回りに「角度」の角度にある円周上の点のｘ座標を求める関数
    Public Function 円周のｘ座標(ByVal x As Integer, ByVal 半径 As Integer, ByVal 角度 As Double) As Integer
        Return x + 半径 * Math.Sin(角度)
    End Function

    '中心のy座標が「y」、半径が「半径」、円の一番下の点から反時計回りに「角度」の角度にある円周上の点のｘ座標を求める関数
    Public Function 円周のｙ座標(ByVal y As Integer, ByVal 半径 As Integer, ByVal 角度 As Double) As Integer
        Return y - 半径 * Math.Cos(角度)
    End Function

    '中心の座標が (x, y)、半径が「半径」の円を描画する関数
    Public Sub 円を描く(ByVal x As Integer, ByVal y As Integer, _
                    ByVal 半径 As Integer, ByVal g As Graphics, ByVal ペン As Pen)
        g.DrawEllipse(ペン, x - 半径, y - 半径, 半径 * 2, 半径 * 2)

    End Sub
End Class
